﻿

(function(cartids){

    /**
     * 原始价格，页面初始化就获取，避免值被改变
     */
    var coursePrice = getOrSetTotalPrice();

    /**
     * 获取或重新设置总价
     */
    function getOrSetTotalPrice(val){
        
        var el = $('#tl_money');
        if(val){
            el.val(val);
            
        }else{
            return Number(el.val())
        }
    }

    /**
     * 可能存在1～n个商品
     */
    var originalTotalPrice = 0;
    $(cartids).each(function(){
        var cartid = this.value;
        
        /**
         * 按课时购买会存在价格信息错误
         * 对此重新计算
         */
        var price = Number($('#price_'+cartid).val());
        var ygp_price = Number($('#ygp_'+cartid).val()); 
        if(ygp_price > 0){
            price -= ygp_price; 
            price = Math.max(0,price);
            $('#price_'+cartid).val(price.toFixed(2));
            $('#r_'+cartid).html(price.toFixed(2))
        }else{
            price = Number($('#price_'+cartid).val())
        }
        originalTotalPrice += price
        
        /**
         * 给课程资料复选框添加点击事件
         */
        var infoCheckboxTarget = document.getElementById('zl'+cartid);
        $(infoCheckboxTarget).click(function(){
            part_consignee_display()
        })

    });
    
    
    /**
     * 重新设置总价
     */
    getOrSetTotalPrice(originalTotalPrice.toFixed(2))
    coursePrice = originalTotalPrice;
    /**
     * 计算价格
     */
    function recalculatePrice(){

        var totalPrice = 0;
        $(cartids).each(function(){
            var cartid = this.value;
            var price = Number($("#r_"+cartid).text());
            /**
             * 是否需要课程资料
             * 计算资料价钱
             */
            var infoCheckboxTarget =  document.getElementById('zl'+cartid);
            if(infoCheckboxTarget && infoCheckboxTarget.checked){
                price += Number($('#nt_'+cartid).text())
            }
            /**
             * 是否需要开发票
             * 计算发票价钱
             */
            if(isInvoice()){
                price += Number($('#t_'+cartid).text()) 
            }
            
            totalPrice += price

        });
        
        /**
         * 更新未抵扣优惠之前的总价
         */
        
        getOrSetTotalPrice(totalPrice.toFixed(2))

        /**
         * 减去抵扣金额
         */
        totalPrice -= Number($('#Voucher').text());
        totalPrice = Math.max(0,totalPrice);
        
        $('#sf_money').html(totalPrice.toFixed(2))
        if(document.getElementById('my_27').checked){
            var umoeny = Number($('#umoeny').text());
            $('#linepay_money_27').html('￥'+Math.min(totalPrice,umoeny).toFixed(2));
            $('#user_pay_money').val(Math.min(totalPrice,umoeny).toFixed(2))
            if(umoeny < totalPrice){
                console.log(1)
                $('#linepay_money_26').html('￥'+(totalPrice-umoeny).toFixed(2))
            }else{
                console.log(2)
                $('#linepay_money_26').html('¥0.00')
            }
        }else{
            console.log(totalPrice,44)
            $('#linepay_money_26').html('¥'+totalPrice.toFixed(2))
        }
        
        

    }

    window.recalculatePrice = recalculatePrice;


    /**
     * 需要课程资料则显示收货地址
     * 多个课程如有一个课程需要资料，则显示收货地址
     */
    function part_consignee_display(){
        
        var isPurchaseInformation = false;
        for(var i=0;i<cartids.length;i++){
            var cartid = cartids[i].value;
            var infoCheckboxTarget = document.getElementById('zl'+cartid);
            isPurchaseInformation = infoCheckboxTarget ? infoCheckboxTarget.checked : false;
            if(isPurchaseInformation){
                break
            } 
        }
        if(isInvoice() || isPurchaseInformation){
            $('#part_consignee').show()
        }else{
            $('#part_consignee').hide();
        }
        
    }
    part_consignee_display();
    
    /**
     * 是否需要开发票
     */
    var invoiceInfoTarget = document.getElementById('InvoiceInfo');
    function isInvoice(){
        return (Number($('input[name="invoiceId"]:checked').val()) > 0 && invoiceInfoTarget && invoiceInfoTarget.checked) ? true : false
    }

    /**
     * 发票信息 
     */
    if(invoiceInfoTarget){
        invoiceInfoTarget.checked ? $('#showInvoice').show() : $('#showInvoice').hide();
    }
    $(invoiceInfoTarget).click(function(){
        this.checked ? $('#showInvoice').show() : $('#showInvoice').hide()
        part_consignee_display();
        IsContainTax();
    });

    /**
     * 选择发票类型 
     */
    window.OrderCalculat = function (){
        part_consignee_display()
        IsContainTax()
    } 

    /**
     * 显示税金（开具发票需要税金）
     */
    function IsContainTax(){
        isInvoice() ? $('.course_tax').show() : $('.course_tax').hide();
        recalculatePrice();
    }
    
    /**
     * 判断是否显示税金，并重新计算价格
     */
    IsContainTax();

    /**
     * 提交订单
     */
    window.submitOrder = function(){
        if(isInvoice() && $('[name="addressId"]:checked').val() == 0){
            KesionJS.Alert('请先设置您的收货地址')
            return false
        }
        
    }


    /**
     * 设置课程的课时的价格
     */
    window.setprice = function(cartid, pid, obj) {
        var oprice = parseFloat($("#price_" + cartid).val());
        var price = 0.00;
        //设置价格,判断全选状态
        var nochekcall = 0;
        //设置全选与反选
        if (pid <= 0) {
            $("input[name=group" + cartid + "]").each(function () {
                if ($(this).attr("checked")) {
                    if (pid == -1) {
                        $(this).attr("checked", false);
                        setperiod(cartid, $(this).val());
                    }
                }
                else {
                    nochekcall = 1;
                    if (pid == 0) {
                        $(this).attr("checked", true);
                        setperiod(cartid, $(this).val());
                    }
                }

            });
            if (pid == 0) {
                $("#checkall" + cartid).attr("onclick", "setprice('" + cartid + "',-1,this)")
            }
            else if (pid == -1) {
                $("#checkall" + cartid).attr("onclick", "setprice('" + cartid + "',0,this)")
            }
        }
        
        var checkall = 0;
        $("input[name=group" + cartid + "]").each(function () {

            if ($(this).attr("checked")) {
                var id = $(this).val();
                price += parseFloat($("#" + cartid + "p_" + id).val());
                checkall = 1;
            }
            else {
                nochekcall = 1;
            }

        });
        
        if (pid > 0) {
            setperiod(cartid, pid);
        }
        //已购买
        var ygpprice = parseFloat($("#ygp_" + cartid).val());
        if (nochekcall == 0) {
            $("#checkall" + cartid).attr("onclick", "setprice('" + cartid + "',-1,this)");
            $("#checkall" + cartid).attr("checked", true);
            
            price = oprice;//全选，设置价格为课程价格

        }
        else if (nochekcall == 1 && obj !== document.getElementById("checkall" + cartid)) {
            if(obj === document.getElementById("checkall" + cartid)){
                price = oprice;
            }else{
                $("#checkall" + cartid).attr("onclick", "setprice('" + cartid + "',0,this)");
                $("#checkall" + cartid).attr("checked", false);
            }
        }
        if (checkall == 0 || obj === document.getElementById("checkall" + cartid)) {
            price = oprice; //都未选，设置价格为课程价格
            $("#period" + cartid).val("");
        }
        
        if(Number(price) > coursePrice){
            
            price = coursePrice
        };
        //设置价格
        price = price.toFixed(2);
        $("#r_" + cartid).html(price);
        settax(cartid);
    }
        
    /**
     * 计算资料的价格
     */
    window.setfileprice = function(cartid, price, obj) {
        //选中状态
        if (!$(obj).attr("checked") || parseFloat(price) <= 0) {
            $("#nt_" + cartid).html("0.00");
            $("#note" + cartid).val("0.00");
            $('#part_consignee').hide();
        }
        else if ($(obj).attr("checked")) {
            $("#nt_" + cartid).html(price);
            $("#note" + cartid).val(price);

            $('#part_consignee').show();


        }
        settax(cartid);
    }
    /**
     * 计算税金的价格
     */
    window.settax = function(cartid) {
        var newtax = 0.00;
        newtax = (parseFloat($("#nt_" + cartid).html()) + parseFloat($("#r_" + cartid).html())) * parseFloat($("#tax_" + cartid).val());
        if (newtax > newtax.toFixed(2)) {
            newtax = (parseFloat(newtax.toFixed(2)) + parseFloat("0.01")).toFixed(2);
        }
        $("#t_" + cartid).html(newtax);
        $("#tax" + cartid).val(newtax);
        recalculatePrice();
    }
    /**
     * 计算课时
     */
    window.setperiod = function(cartid, pid) {
        var totalid = $("#period" + cartid).val();
        if (("," + totalid + ",").indexOf("," + pid + ",") == -1) {
            if (totalid == "") { totalid = pid; }
            else {
                totalid += "," + pid;
            }
        }
        else {
            totalid = totalid.replace(pid + ",", "");
            totalid = totalid.replace(pid, "");
        }
        $("#period" + cartid).val(totalid);

    }

    /**
     * 计算使用优惠券或者红包，使用返现金额
     */

    window.shc = function(v, t) {
        if (v == "0") {
            jQuery("#dyq").css("display", "none");//抵用券隐藏
            if (t == 2) {
                jQuery("#yhj_money").val(0);
                c_cahe();
            } else {
                jQuery("#hongbao_money").val(0);
            }
            var g = getprices();
            jQuery("#sf_money").html("￥" + g);
            c_cahe();
        } else {

            jQuery("#dyq").css("display", "");//抵用券显示 

            checkcopnum(v, t);
        }
    }
    /**
     * 抵用
     */
    window.c_cahe = function() {
        
        if ($("#cash_m").attr("checked")) {
            jQuery("#Voucher").html((parseFloat(jQuery("#cash_money").val()) + parseFloat(jQuery("#hongbao_money").val()) + parseFloat(jQuery("#yhj_money").val())).toFixed(2));
        } else {
            jQuery("#Voucher").html((parseFloat(jQuery("#hongbao_money").val()) + parseFloat(jQuery("#yhj_money").val())).toFixed(2));

        }

        recalculatePrice();
    }
    /**
     * 优惠券号
     */
    window.checkcopnum = function(copnum, type) {
        jQuery("#copnu_id").val();
        var m = jQuery("#tl_money").val();
        jQuery("#sf_money").html(m);
        jQuery("#user_pay_money").val(m);
        if (copnum == '') {
            alert(' 请输入优惠券号');
            jQuery(".write-number").focus();

        } else {
            $.ajax({
                url: "/index.aspx?c=course&a=orderinfo&action=check&rnd=" + Math.random() + "&as=" + coursePrice + "&copnum=" + copnum,
                context: document.body,
                type: "GET",
                success: function (data) {
                    var ss = data.split('|');
                    if (ss[0] == 'ok') {
                        if (coursePrice > parseFloat(ss[1])) {
                            if (type == 2) {
                            
                                jQuery("#yhj_money").val(ss[1]);
                                jQuery("#copnu_id").val(copnum);
                            
                            } else {
                                jQuery("#hongbao_money").val(ss[1]);
                            
                            }
                            var p = getprices();
                            jQuery("#sf_money").html("￥" + p);
                            c_cahe();
                        } else {
                        
                            if (type == 1) {
                                $("#hongfenxiao").val(0).change();
                            } else {
                                $("#fenxiao").val(0).change();
                            }
                            alert('抵用金额大于课程价格不能抵用');
                        }
                    } else {
                        alert('您输入优惠券号不存在');
                        $(".write-number").focus();
                    }
                }
            });
        }
    }

    /**
     * 优惠券使用按钮
     */
    window.sear_cher = function() {
        var copnum = jQuery(".write-number").val();
        checkcopnum(copnum, 2)
    }

})(document.getElementsByName('cartid'));







